<?php
/**
 * App layout with shared header/nav + footer
 * @var \App\View\AppView $this
 */

// Helper to mark the active link
$ctrl   = $this->request->getParam('controller');
$action = $this->request->getParam('action');
$curr   = strtolower($ctrl . '/' . $action);
$activeClass = function (string $expect) use ($curr) {
    return strtolower($expect) === $curr ? 'nav-link active' : 'nav-link';
};
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <?= $this->Html->charset() ?>
    <meta name="viewport" content="width=device-width, initial-scale=1" />
    <title><?= $this->fetch('title') ?: 'Salty & Bold' ?></title>
    <?= $this->Html->meta('icon') ?>

    <?= $this->Html->css(['normalize.min', 'milligram.min']) ?>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@400;600;700;800&family=Playfair+Display:wght@700;800&display=swap" rel="stylesheet">

    <style>
        :root{
            --bg:#fff8f1;
            --card:#fff;
            --ink:#2f241a;
            --muted:#7a6b62;
            --accent:#2aa8a5;
            --cta:#f2a45e;
            --cta-ink:#2b180a;
            --shadow:0 12px 32px rgba(0,0,0,.10);
            --soft-shadow:0 6px 18px rgba(0,0,0,.08);
            --radius:18px;
        }
        *{box-sizing:border-box}
        body{ margin:0; font-family:"Inter",system-ui,-apple-system,Segoe UI,Roboto,Helvetica,Arial; color:var(--ink); background:var(--bg); }
        h1{font-family:"Playfair Display",serif;font-size:42px;line-height:1.2;margin:.2rem 0 .6rem}
        h2{font-family:"Playfair Display",serif;font-size:26px;margin:.5rem 0}
        .muted{color:var(--muted)}
        .container{max-width:1080px;margin:0 auto;padding:0 18px}

        /* NAV BAR */
        .sb-nav{ position:sticky; top:0; z-index:50; background:#fff8f1e6; backdrop-filter:saturate(160%) blur(6px); border-bottom:1px solid rgba(0,0,0,.05) }
        .sb-nav .row{
            height:66px; display:flex; align-items:center; justify-content:space-between; position:relative;
            gap:16px;
        }

        /* Brand (logo) */
        .brand{ display:flex; align-items:center; gap:10px; font-weight:800; font-size:20px; color:var(--ink); text-decoration:none; white-space:nowrap }
        .brand img{
            height:52px;            /* bigger */
            width:52px;             /* make square */
            border-radius:50%;      /* circle */
            object-fit:cover;       /* nicely fill the circle */
            border:2px solid var(--accent); /* subtle ring (optional) */
        }
        .visually-hidden{ position:absolute!important; clip:rect(1px,1px,1px,1px); padding:0; border:0; height:1px; width:1px; overflow:hidden; white-space:nowrap }

        /* NAV GROUPS: left brand, center links, right account */
        .nav-area{ display:flex; align-items:center; justify-content:space-between; gap:16px; flex:1; }
        .nav-left{ flex:0 0 auto; }
        .nav-center{ flex:1 1 auto; display:flex; justify-content:center; }
        .nav-right{ flex:0 0 auto; display:flex; align-items:center; gap:10px; }

        /* Desktop nav links */
        .nav{ display:flex; align-items:center; gap:10px; flex-wrap:wrap }
        .nav-link{
            display:inline-flex; align-items:center; gap:8px;
            padding:10px 14px; border-radius:12px;
            font-weight:800; text-decoration:none;
            color:var(--ink); border:1px solid transparent; background:transparent;
            transition:background .15s ease, box-shadow .15s ease, color .15s ease, border-color .15s ease, transform .06s ease;
        }
        .nav-link:hover{
            background:#fff; border-color:rgba(0,0,0,.08); box-shadow:var(--soft-shadow);
        }
        .nav-link:active{ transform:translateY(1px); }
        .nav-link.active{
            background:var(--accent); color:#fff; box-shadow:0 8px 22px rgba(42,168,165,.35);
        }

        /* Account dropdown (desktop) */
        .account{ position:relative }
        .account-btn{
            display:inline-flex; align-items:center; gap:8px;
            padding:10px 12px; border-radius:12px;
            background:#fff; border:1px solid rgba(0,0,0,.08);
            font-weight:800; cursor:pointer; color:var(--ink);
            box-shadow:0 2px 8px rgba(0,0,0,.05);
        }
        .account-btn:hover{ background:#fff5ec }
        .account-menu{
            display:none; position:absolute; right:0; top:48px; min-width:220px;
            background:#fff;
            border:1px solid rgba(0,0,0,.08);
            border-radius:14px; box-shadow:var(--shadow); padding:8px;
        }
        .account-menu::before{
            content:""; position:absolute; top:-8px; right:18px;
            width:14px; height:14px; background:#fff;
            border-left:1px solid rgba(0,0,0,.08);
            border-top:1px solid rgba(0,0,0,.08);
            transform:rotate(45deg);
        }
        .account-menu a{
            display:block; padding:10px 12px; border-radius:10px;
            color:var(--ink); text-decoration:none; font-weight:700;
        }
        .account-menu a:hover{ background:#fff4ea }
        .account.open .account-menu{ display:block; }

        /* Mobile controls */
        .nav-toggle{ position:absolute; opacity:0; width:1px; height:1px; overflow:hidden; pointer-events:none; }
        .nav-trigger{ display:none; align-items:center; gap:8px; cursor:pointer; font-weight:800; padding:8px 12px; border-radius:10px; border:1px solid rgba(0,0,0,.08); background:#fff; }
        .nav-trigger .bars{ display:inline-block; width:18px; height:12px; position:relative }
        .nav-trigger .bars:before, .nav-trigger .bars:after, .nav-trigger .bars span{ content:""; position:absolute; left:0; right:0; height:2px; background:var(--ink); border-radius:2px; }
        .nav-trigger .bars:before{ top:0 } .nav-trigger .bars span{ top:5px } .nav-trigger .bars:after{ bottom:0 }

        .dropdown{ display:none; }

        /* Mobile dropdown */
        @media (max-width: 860px){
            .nav-center{ display:none; } /* hide desktop link row */
            .nav-trigger{ display:flex; }
            .dropdown{
                display:none; position:absolute; right:10px; top:66px; width:260px; background:#fff;
                border:1px solid rgba(0,0,0,.08); border-radius:14px; box-shadow:var(--shadow); padding:10px;
            }
            .dropdown a{ display:block; padding:10px 12px; border-radius:10px; text-decoration:none; color:var(--ink); font-weight:700 }
            .dropdown a:hover{ background:#fff4ea }
            .dropdown .dropdown-title{ padding:8px 12px; font-weight:800; color:var(--muted); font-size:12px; text-transform:uppercase; letter-spacing:.04em }
            .nav-toggle:checked ~ .dropdown{ display:block; }
        }

        /* HERO (only on home) */
        .hero-cover{
            margin:20px 0 0; border-radius:22px; padding:60px 30px; text-align:center;
            background: radial-gradient(circle at 20% 20%, #fff4ea, transparent 60%),
                        radial-gradient(circle at 80% 30%, #fce9d9, transparent 65%),
                        linear-gradient(to right, #fffaf5, #fef6f0);
            box-shadow:var(--shadow);
        }
        .hero-cover h1{ margin-bottom:12px; font-size:32px }
        .hero-cover .muted{ max-width:640px; margin:0 auto 20px; display:block; font-size:16px }
        .hero-emoji{ font-size:36px; margin-bottom:16px }

        /* BUTTONS */
        .btn{ display:inline-flex; align-items:center; gap:10px; padding:14px 28px; border-radius:999px; border:0; cursor:pointer; font-weight:800; text-decoration:none; transition:transform .06s ease, box-shadow .18s ease }
        .btn-primary{ background:var(--cta); color:var(--cta-ink); box-shadow:0 10px 28px rgba(242,164,94,.35) }
        .btn-primary:hover{ transform:translateY(-2px) }
        .btn-primary:active{ transform:translateY(0) }
        .btn-ghost{background:#fff;border:1px solid rgba(0,0,0,.08);color:var(--ink);border-radius:999px;padding:12px 20px;font-weight:800;display:inline-flex;align-items:center;gap:8px;text-decoration:none}
        .btn-ghost:hover{background:#fff5ec}

        /* PRODUCT GRID */
        .highlights{margin-top:40px}
        .product-grid{display:grid; grid-template-columns:repeat(auto-fit,minmax(220px,1fr)); gap:20px; margin-top:20px}
        .product{background:var(--card); border-radius:var(--radius); box-shadow:var(--shadow); padding:18px; text-align:center; transition:transform .08s ease}
        .product:hover{transform:translateY(-3px)}
        .product .title{font-weight:700; margin:10px 0 6px}
        .price{font-weight:700; color:var(--accent)}

        /* FOOTER */
        footer{ margin-top:40px; padding:44px 0; color:var(--muted); border-top:1px solid rgba(0,0,0,.05) }
        .footer-grid{ display:grid; grid-template-columns:1fr 1fr; gap:30px; align-items:start }
        .footer-links a{ color:var(--accent); text-decoration:none; font-weight:600 }
        .footer-links a:hover{ text-decoration:underline }
        .footer-block-title{ font-weight:700; color:var(--ink); margin-bottom:8px }
        .social{ display:flex; gap:12px; margin-top:8px }
        .social a{ display:inline-flex; align-items:center; justify-content:center; width:38px; height:38px; border-radius:999px; background:#fff; border:1px solid rgba(0,0,0,.08); box-shadow:0 2px 6px rgba(0,0,0,.06) }
        .social a:hover{ background:#fff5ec }
        .social svg{ width:18px; height:18px; stroke:#3b2a1d }
        @media(max-width:760px){
            .footer-grid{ grid-template-columns:1fr; text-align:center }
            .social{ justify-content:center }
        }
    </style>

    <?= $this->fetch('meta') ?>
    <?= $this->fetch('css') ?>
    <?= $this->fetch('script') ?>

    <!-- Google reCAPTCHA -->
    <script src="https://www.google.com/recaptcha/api.js" async defer></script>
</head>
<body>

    <!-- Header / Nav -->
    <header class="sb-nav">
        <div class="container row">
            <div class="nav-area">
                <!-- Left: Brand -->
                <div class="nav-left">
                    <a class="brand" href="/">
                        <?= $this->Html->image('/img/Snack.png', [
                            'alt' => 'Salty & Bold logo',
                            'height' => '52',
                            'width'  => '52'
                        ]) ?>
                        <span class="visually-hidden">Salty &amp; Bold</span>
                    </a>
                </div>

                <!-- Center: Main links -->
                <div class="nav-center">
                    <nav class="nav" aria-label="Primary">
                        <?= $this->Html->link('Home', ['controller' => 'Pages', 'action' => 'home'], ['class' => $activeClass('Pages/home')]) ?>
                        <?= $this->Html->link('Products', ['controller' => 'Products', 'action' => 'listProducts'], ['class' => $activeClass('Products/listProducts')]) ?>
                        <?= $this->Html->link('Contact us', ['controller' => 'ContactSubmissions', 'action' => 'add'], ['class' => $activeClass('ContactSubmissions/add')]) ?>
                    </nav>
                </div>

                <!-- Right: Account dropdown + mobile trigger -->
                <div class="nav-right">
                    <div class="account" id="accountDropdown">
                        <button class="account-btn" id="accountToggle" aria-haspopup="true" aria-expanded="false">
                            <span>Account</span>
                            <svg width="16" height="16" viewBox="0 0 24 24" aria-hidden="true">
                                <path d="M6 9l6 6 6-6" stroke="currentColor" stroke-width="2" stroke-linecap="round"/>
                            </svg>
                        </button>
                        <div class="account-menu" id="accountMenu" role="menu">
                            <a href="<?= $this->Url->build('/login') ?>">Log in</a>
                            <a href="<?= $this->Url->build('/signup') ?>">Sign up</a>
                        </div>
                    </div>

                    <!-- Mobile trigger -->
                    <input id="nav-toggle" type="checkbox" class="nav-toggle" aria-label="Toggle menu">
                    <label for="nav-toggle" class="nav-trigger">
                        <span class="bars"><span></span></span>
                        <span>Menu</span>
                    </label>

                    <!-- Mobile dropdown -->
                    <div class="dropdown" role="menu" aria-labelledby="nav-toggle">
                        <?= $this->Html->link('Home', ['controller' => 'Pages', 'action' => 'home']) ?>
                        <?= $this->Html->link('Products', ['controller' => 'Products', 'action' => 'listProducts']) ?>
                        <?= $this->Html->link('Contact us', ['controller' => 'ContactSubmissions', 'action' => 'add']) ?>
                        <div class="dropdown-title">Account</div>
                        <?= $this->Html->link('Log in', '/login') ?>
                        <?= $this->Html->link('Sign up', ['controller' => 'Users', 'action' => 'register']) ?>
                    </div>
                </div>
            </div>
        </div>
    </header>

    <!-- Hero only on Home -->
    <?php if ($ctrl === 'Pages' && $action === 'home'): ?>
        <div class="container">
            <section class="hero-cover">
                <div class="hero-emoji">🥨 🍪 🥟 🍿</div>
                <h1>Salty Snacks, Bold Flavours</h1>
                <span class="muted">From pretzels and crackers to cookies and popcorn — baked fresh daily with premium ingredients. Perfect for pick-up or delivery.</span>
                <br><br>
                <?= $this->Html->link('Order Now', '/products/list_products', ['class' => 'btn btn-primary']) ?>
            </section>
        </div>
    <?php endif; ?>

    <!-- Page content -->
    <main class="container section">
        <?= $this->Flash->render() ?>
        <?= $this->fetch('content') ?>
    </main>

    <!-- Footer -->
    <footer>
        <div class="container footer-grid">
            <!-- Left: brand & socials -->
            <div>
                <div class="footer-block-title" style="font-size:18px;">Salty &amp; Bold</div>
                <div class="muted">Baked fresh daily — pickup &amp; delivery</div>

                <div style="margin-top:16px;">
                    <div class="footer-block-title">Follow us</div>
                    <div class="social" aria-label="Social media">
                        <!-- Instagram -->
                        <a href="https://instagram.com/" target="_blank" rel="noopener noreferrer" aria-label="Instagram">
                            <svg viewBox="0 0 24 24" fill="none"><rect x="3" y="3" width="18" height="18" rx="5"></rect><circle cx="12" cy="12" r="3.5"></circle><circle cx="17.5" cy="6.5" r="1.2" fill="#3b2a1d"></circle></svg>
                        </a>
                        <!-- Facebook -->
                        <a href="https://facebook.com/" target="_blank" rel="noopener noreferrer" aria-label="Facebook">
                            <svg viewBox="0 0 24 24" fill="none"><path d="M14.5 8H13a3 3 0 0 0-3 3v10" stroke-width="2"></path><path d="M9.5 12h5" stroke-width="2"></path><rect x="3" y="3" width="18" height="18" rx="4" stroke-width="2"></rect></svg>
                        </a>
                        <!-- TikTok -->
                        <a href="https://www.tiktok.com/" target="_blank" rel="noopener noreferrer" aria-label="TikTok">
                            <svg viewBox="0 0 24 24" fill="none"><path d="M14 3v7a4 4 0 1 1-4 4V7" stroke-width="2"></path><path d="M14 5c1.2 1.6 3.2 2.6 5 2.7" stroke-width="2"></path><rect x="3" y="3" width="18" height="18" rx="4" stroke-width="2"></rect></svg>
                        </a>
                    </div>
                </div>
            </div>

            <!-- Right: info -->
            <div class="footer-links">
                <div class="footer-block-title">Hours</div>
                <div class="muted" style="margin-bottom:12px;">Mon–Sat 9am–6pm</div>

                <div class="footer-block-title">Address</div>
                <div style="margin-bottom:12px;">
                    <a href="https://www.google.com/maps/search/?api=1&query=Wellington+Rd,+Clayton+VIC+3800"
                       target="_blank" rel="noopener noreferrer" aria-label="Open in Google Maps">
                        Wellington Rd, Clayton VIC 3800
                    </a>
                </div>

                <div class="footer-block-title">Contact</div>
                <div>
                    <a href="mailto:hello@saltybold.test" aria-label="Email us">hello@saltybold.test</a>
                    &nbsp;•&nbsp;
                    <a href="tel:+61390000000" aria-label="Call us">(03) 9000 0000</a>
                </div>
            </div>
        </div>
    </footer>

    <script>
      // Desktop Account dropdown toggle + click-away close + ESC close
      (function(){
        const account = document.getElementById('accountDropdown');
        const btn = document.getElementById('accountToggle');
        const menu = document.getElementById('accountMenu');
        if(!account || !btn || !menu) return;

        const open = () => { account.classList.add('open'); btn.setAttribute('aria-expanded','true'); };
        const close = () => { account.classList.remove('open'); btn.setAttribute('aria-expanded','false'); };

        btn.addEventListener('click', function(e){
          e.preventDefault();
          account.classList.contains('open') ? close() : open();
        });

        document.addEventListener('click', function(e){
          if(!account.contains(e.target)) close();
        });

        document.addEventListener('keydown', function(e){
          if(e.key === 'Escape') close();
        });
      })();
    </script>

</body>
</html>
