<h2>Thanks for your order, <?= h($customer['name']) ?>!</h2>
<p>Placed at: <?= h($placedAt->i18nFormat('yyyy-MM-dd HH:mm')) ?></p>

<table border="1" cellpadding="6" cellspacing="0">
    <thead><tr><th>Product</th><th>Price</th><th>Qty</th><th>Line</th></tr></thead>
    <tbody>
    <?php foreach ($items as $it): ?>
        <tr>
            <td><?= h($it['name']) ?></td>
            <td><?= number_format($it['price'], 2) ?></td>
            <td><?= (int)$it['qty'] ?></td>
            <td><?= number_format($it['price'] * $it['qty'], 2) ?></td>
        </tr>
    <?php endforeach; ?>
    </tbody>
    <tfoot>
    <tr><th colspan="3" align="right">Total</th><th><?= number_format($total, 2) ?></th></tr>
    </tfoot>
</table>

<h3>Delivery</h3>
<p>
    <?= nl2br(h($customer['address'])) ?><br>
    <?php if (!empty($customer['phone'])): ?>Phone: <?= h($customer['phone']) ?><br><?php endif; ?>
</p>

<?php if (!empty($customer['note'])): ?>
    <p><strong>Notes:</strong> <?= nl2br(h($customer['note'])) ?></p>
<?php endif; ?>
