<?php
// Simple helpers for active link state
$current = strtolower($this->request->getParam('controller') . '/' . $this->request->getParam('action'));
$active = function(string $path) use ($current) {
    return (strtolower($path) === $current) ? 'nav-link active' : 'nav-link';
};
?>
<header class="site-header">
  <div class="nav-wrap">
    <!-- Brand -->
    <a class="brand" href="<?= $this->Url->build('/home') ?>">Salty &amp; Bold</a>

    <!-- Primary links -->
    <nav class="nav-links">
      <a class="<?= $active('Pages/home')   ?>" href="<?= $this->Url->build('/home') ?>">Home</a>
      <a class="<?= $active('Products/index') ?>" href="<?= $this->Url->build(['controller' => 'Products', 'action' => 'index']) ?>">Products</a>
      <a class="<?= $active('Pages/contact') ?>" href="<?= $this->Url->build('/pages/contact') ?>">Contact us</a>
      <a class="<?= $active('Admin/Dashboard/index') ?>" href="<?= $this->Url->build(['prefix' => 'Admin', 'controller' => 'Dashboard', 'action' => 'index']) ?>">Admin</a>
    </nav>

    <!-- Account dropdown -->
    <div class="account">
      <button id="accountToggle" class="account-btn" aria-haspopup="true" aria-expanded="false">
        <span>Account</span>
        <svg width="16" height="16" viewBox="0 0 24 24" aria-hidden="true"><path d="M6 9l6 6 6-6" stroke="currentColor" stroke-width="2" stroke-linecap="round"/></svg>
      </button>

      <div id="accountMenu" class="dropdown" role="menu">
        <?php
        // If you have authentication set up, you can switch the menu like this:
        $loggedIn = isset($this->Identity) && $this->Identity->isLoggedIn();
        if ($loggedIn):
        ?>
          <a class="dropdown-item" href="<?= $this->Url->build('/profile') ?>">Profile</a>
          <a class="dropdown-item" href="<?= $this->Url->build('/logout') ?>">Log out</a>
        <?php else: ?>
          <a class="dropdown-item" href="<?= $this->Url->build('/login') ?>">Log in</a>
          <a class="dropdown-item" href="<?= $this->Url->build('/signup') ?>">Sign up</a>
        <?php endif; ?>
      </div>
    </div>
  </div>
</header>

