<?php
/**
 * Product detail page
 * @var \App\Model\Entity\Product $product
 */
$this->assign('title', 'Salty & Bold — ' . h($product->name));
?>

<style>
/* --- local styles just for this page --- */
.pd-card{padding:28px;border-radius:20px;box-shadow:0 12px 32px rgba(0,0,0,.08);background:#fff}
.pd-grid{display:grid;grid-template-columns:1.2fr .8fr;gap:28px;align-items:start}
@media(max-width:900px){.pd-grid{grid-template-columns:1fr}}
.pd-img{width:100%;height:460px;object-fit:cover;border-radius:16px;background:#faf5ef}
@media(max-width:900px){.pd-img{height:320px}}
.pd-title{font-family:"Playfair Display",serif;font-size:36px;margin:0 0 10px}
.pd-desc{color:#7a6b62;margin:8px 0 18px;line-height:1.55}
.pd-badges{display:flex;gap:8px;flex-wrap:wrap;margin:8px 0}
.pd-badge{background:#fff5ec;border:1px solid rgba(0,0,0,.06);color:#8b4d1f;font-weight:700;font-size:12px;padding:6px 10px;border-radius:999px}

/* action bar: price + buttons neatly aligned */
.pd-actions{display:flex;align-items:center;justify-content:space-between;gap:18px;flex-wrap:wrap;margin-top:8px}
.pd-price{font-size:28px;font-weight:800;color:#2aa8a5}
.pd-buttons{display:flex;gap:12px;flex-wrap:wrap}

/* subtle secondary button */
.btn-ghost{background:#fff;border:1px solid rgba(0,0,0,.08);color:#3b2a1d;border-radius:999px;padding:12px 20px;font-weight:800;display:inline-flex;align-items:center;gap:8px;text-decoration:none}
.btn-ghost:hover{background:#fff5ec}

.pd-meta{margin-top:10px;color:#7a6b62;font-size:14px}
</style>

<div class="container" style="margin-top:32px;margin-bottom:40px;">
  <div class="pd-card">

    <!-- Breadcrumb -->
    <nav class="muted" aria-label="Breadcrumb" style="font-size:14px;margin-bottom:12px;">
      <a href="/home" style="text-decoration:none;color:inherit;">Home</a> ›
      <a href="/products/listProducts" style="text-decoration:none;color:inherit;">Products</a> ›
      <span><?= h($product->name) ?></span>
    </nav>

    <div class="pd-grid">
      <!-- Left: Image -->
      <div>
        <?php if (!empty($product->product_image_url)): ?>
          <img class="pd-img" src="<?= h($product->product_image_url) ?>" alt="<?= h($product->name) ?>">
        <?php else: ?>
          <div class="pd-img" style="display:flex;align-items:center;justify-content:center;color:#7a6b62;">No image available</div>
        <?php endif; ?>
      </div>

      <!-- Right: Details -->
      <div>
        <h1 class="pd-title"><?= h($product->name) ?></h1>

        <div class="pd-badges">
          <?php if (!empty($product->is_seasonal)): ?>
            <span class="pd-badge">Seasonal</span>
          <?php endif; ?>
          <?php if (!empty($product->is_available)): ?>
            <span class="pd-badge">In Stock</span>
          <?php else: ?>
            <span class="pd-badge" style="background:#fff0f0;color:#a22626;">Out of Stock</span>
          <?php endif; ?>
        </div>

        <?php if (!empty($product->description)): ?>
          <p class="pd-desc"><?= nl2br(h($product->description)) ?></p>
        <?php endif; ?>

        <!-- Action bar -->
        <div class="pd-actions">
          <div class="pd-price">$<?= number_format((float)$product->price, 2) ?></div>

          <div class="pd-buttons">
            <!-- Placeholder order CTA -->
            <a href="#" class="btn btn-primary" style="text-decoration:none;">🛒 Order Now</a>
            <a href="/products/listProducts" class="btn-ghost">← Back to products</a>
          </div>
        </div>

        <!-- Meta -->
        <div class="pd-meta">
          <?php if (isset($product->stock_level)): ?>
            Stock: <?= (int)$product->stock_level ?>
          <?php endif; ?>
          <?php if (!empty($product->modified)): ?>
            • Updated: <?= h($product->modified) ?>
          <?php endif; ?>
        </div>

        <!-- Allergens -->
        <?php if (!empty($product->allergens)): ?>
          <div style="margin-top:18px;">
            <strong>Allergens:</strong>
            <ul style="margin:6px 0;padding-left:20px;">
              <?php foreach ($product->allergens as $allergen): ?>
                <li>
                  <?= h($allergen->allergen_name) ?>
                  <?php if (!empty($allergen->allergen_logo_url)): ?>
                    <img src="<?= h($allergen->allergen_logo_url) ?>"
                         alt="<?= h($allergen->allergen_name) ?>"
                         style="height:18px;margin-left:6px;vertical-align:middle;">
                  <?php endif; ?>
                </li>
              <?php endforeach; ?>
            </ul>
          </div>
        <?php endif; ?>

      </div>
    </div>

  </div>
</div>
