<h1>Products (Admin)</h1>

<p>
    <?= $this->Html->link('Add Product', ['action' => 'add']) ?>
    &nbsp;|&nbsp;
    <?= $this->Html->link('Public listing', ['action' => 'listProducts']) ?>
</p>

<table>
    <thead>
    <tr>
        <th><?= $this->Paginator->sort('id') ?></th>
        <th><?= $this->Paginator->sort('name') ?></th>
        <th><?= $this->Paginator->sort('price') ?></th>
        <th><?= $this->Paginator->sort('is_available', 'Available') ?></th>
        <th><?= $this->Paginator->sort('created') ?></th>
        <th>Actions</th>
    </tr>
    </thead>
    <tbody>
    <?php foreach ($products as $product): ?>
        <tr>
            <td><?= h($product->id) ?></td>
            <td><?= h($product->name) ?></td>
            <td><?= $this->Number->currency($product->price) ?></td>
            <td><?= $product->is_available ? 'Yes' : 'No' ?></td>
            <td><?= $product->created?->i18nFormat('yyyy-MM-dd HH:mm') ?></td>
            <td>
                <?= $this->Html->link('View', ['action' => 'view', $product->id]) ?> |
                <?= $this->Html->link('Edit', ['action' => 'edit', $product->id]) ?> |
                <?= $this->Form->postLink('Delete', ['action' => 'delete', $product->id], [
                    'confirm' => 'Delete this product?'
                ]) ?>
            </td>
        </tr>
    <?php endforeach; ?>
    </tbody>
</table>

<div class="paginator">
    <ul class="pagination">
        <?= $this->Paginator->first('<<') ?>
        <?= $this->Paginator->prev('<') ?>
        <?= $this->Paginator->numbers() ?>
        <?= $this->Paginator->next('>') ?>
        <?= $this->Paginator->last('>>') ?>
    </ul>
    <p><?= $this->Paginator->counter() ?></p>
</div>
