<?php
/**
 * Home page — shows seasonal products from DB
 * @var \App\View\AppView $this
 * @var \Cake\Datasource\ResultSetInterface|\App\Model\Entity\Product[] $seasonal
 */
$this->assign('title', 'Salty & Bold — Salty Snacks, Bold Flavours');
?>

<!-- Seasonal Highlights (from DB) -->
<div class="container highlights">
    <h2 style="text-align:center;">Seasonal Highlights</h2>

    <div class="product-grid">
        <?php if (!empty($seasonal) && count($seasonal) > 0): ?>
            <?php foreach ($seasonal as $p): ?>
                <?php
                    $url = $this->Url->build(['controller' => 'Products', 'action' => 'view', $p->id]);
                    $img = !empty($p->product_image_url) ? h($p->product_image_url) : null;
                ?>
                <a href="<?= $url ?>" class="product" style="text-decoration:none; color:inherit; cursor:pointer;">
                    <?php if ($img): ?>
                        <img src="<?= $img ?>" alt="<?= h($p->name) ?>"
                             style="width:100%; height:150px; object-fit:cover; border-radius:12px; background:#faf5ef;">
                    <?php endif; ?>

                    <div class="title"><?= h($p->name) ?></div>

                    <?php if (!empty($p->description)): ?>
                        <div class="muted" style="min-height:40px;">
                            <?= h($p->description) ?>
                        </div>
                    <?php endif; ?>

                    <!-- ✅ Price or Not Available -->
                    <div class="price" style="margin-top:8px;">
                        <?php if (!empty($p->is_available)): ?>
                            $<?= number_format((float)$p->price, 2) ?>
                        <?php else: ?>
                            <span style="color:#a22626; font-weight:600;">Not Available</span>
                        <?php endif; ?>
                    </div>

                    <!-- ✅ Allergens -->
                    <?php if (!empty($p->allergens)): ?>
                        <div style="margin-top:8px; display:flex; gap:6px; flex-wrap:wrap;">
                            <?php foreach ($p->allergens as $allergen): ?>
                                <span style="font-size:11px; padding:3px 8px; border-radius:999px;
                                             background:#fff0f0; color:#a22626;">
                                    <?= h($allergen->allergen_name) ?>
                                </span>
                            <?php endforeach; ?>
                        </div>
                    <?php endif; ?>

                </a>
            <?php endforeach; ?>
        <?php else: ?>
            <div class="muted" style="grid-column:1 / -1; text-align:center;">
                No seasonal products yet. Browse all <a href="/products">products</a>.
            </div>
        <?php endif; ?>
    </div>
</div>
