<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\ContactSubmission $contactSubmission
 * @var \Cake\Collection\CollectionInterface|string[] $users
 */
?>
<div class="row">
    <div class="column column-80">
        <div class="contactSubmissions form content">
            <?= $this->Form->create($contactSubmission) ?>
            <fieldset>
                <legend><?= __('Add Contact Submission') ?></legend>
                <?php
                    echo $this->Form->control('user_id', ['options' => $users, 'empty' => true]);
                    echo $this->Form->control('name');
                    echo $this->Form->control('email');
                    echo $this->Form->control('phone');
                    echo $this->Form->control('message');
                    echo $this->Form->control('message_status');
                ?>
            </fieldset>

            <!-- Google reCAPTCHA widget -->
            <div style="margin: 12px 0;">
                <div class="g-recaptcha" data-sitekey="6Lf8o8UrAAAAAHeKcSk66_gZVyalobyf0WX4b9LA"></div>
            </div>

            <?= $this->Form->button(__('Submit')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
