
<h1>Your Cart</h1>

<?php if (empty($cart['items'])): ?>
    <p>Your cart is empty.</p>
    <p><?= $this->Html->link('Browse products', ['controller'=>'Products','action'=>'index']) ?></p>
<?php else: ?>
    <?= $this->Form->create(null, ['url' => ['action' => 'update']]) ?>
    <table>
        <thead>
        <tr>
            <th>Product</th>
            <th>Price</th>
            <th>Qty</th>
            <th>Line</th>
            <th></th>
        </tr>
        </thead>
        <tbody>
        <?php foreach ($cart['items'] as $id => $row): ?>
            <tr>
                <td><?= h($row['name']) ?></td>
                <td><?= number_format($row['price'], 2) ?></td>
                <td><?= $this->Form->number("quantities.$id", ['value' => $row['qty'], 'min' => 0]) ?></td>
                <td><?= number_format($row['price'] * $row['qty'], 2) ?></td>
                <td>
                    <?= $this->Html->link('Remove', ['controller' => 'Carts', 'action' => 'removeItem', $id]) ?>
                </td>
            </tr>
        <?php endforeach; ?>
        </tbody>
        <tfoot>
        <tr>
            <th colspan="3" style="text-align:right">Total</th>
            <th><?= number_format($total, 2) ?></th>
            <th></th>
        </tr>
        </tfoot>
    </table>

    <p>
        <?= $this->Form->button('Update cart') ?>
        <?= $this->Form->end() ?>
    </p>

    <p>
        <?= $this->Form->postLink('Clear cart', ['action'=>'clear'], ['confirm'=>'Clear your cart?']) ?>
        &nbsp;|&nbsp;
        <?= $this->Html->link('Checkout', ['action'=>'checkout']) ?>
    </p>
<?php endif; ?>
