<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\AllergensProduct $allergensProduct
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Allergens Product'), ['action' => 'edit', $allergensProduct->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Allergens Product'), ['action' => 'delete', $allergensProduct->id], ['confirm' => __('Are you sure you want to delete # {0}?', $allergensProduct->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Allergens Products'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Allergens Product'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="allergensProducts view content">
            <h3><?= h($allergensProduct->id) ?></h3>
            <table>
                <tr>
                    <th><?= __('Allergen') ?></th>
                    <td><?= $allergensProduct->hasValue('allergen') ? $this->Html->link($allergensProduct->allergen->allergen_name, ['controller' => 'Allergens', 'action' => 'view', $allergensProduct->allergen->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Product') ?></th>
                    <td><?= $allergensProduct->hasValue('product') ? $this->Html->link($allergensProduct->product->name, ['controller' => 'Products', 'action' => 'view', $allergensProduct->product->id]) : '' ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($allergensProduct->id) ?></td>
                </tr>
            </table>
        </div>
    </div>
</div>