<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\AllergensProduct> $allergensProducts
 */
?>
<div class="allergensProducts index content">
    <?= $this->Html->link(__('New Allergens Product'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Allergens Products') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('allergen_id') ?></th>
                    <th><?= $this->Paginator->sort('product_id') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($allergensProducts as $allergensProduct): ?>
                <tr>
                    <td><?= $this->Number->format($allergensProduct->id) ?></td>
                    <td><?= $allergensProduct->hasValue('allergen') ? $this->Html->link($allergensProduct->allergen->allergen_name, ['controller' => 'Allergens', 'action' => 'view', $allergensProduct->allergen->id]) : '' ?></td>
                    <td><?= $allergensProduct->hasValue('product') ? $this->Html->link($allergensProduct->product->name, ['controller' => 'Products', 'action' => 'view', $allergensProduct->product->id]) : '' ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $allergensProduct->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $allergensProduct->id]) ?>
                        <?= $this->Form->postLink(
                            __('Delete'),
                            ['action' => 'delete', $allergensProduct->id],
                            [
                                'method' => 'delete',
                                'confirm' => __('Are you sure you want to delete # {0}?', $allergensProduct->id),
                            ]
                        ) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>