<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\AllergensProduct $allergensProduct
 * @var string[]|\Cake\Collection\CollectionInterface $allergens
 * @var string[]|\Cake\Collection\CollectionInterface $products
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Form->postLink(
                __('Delete'),
                ['action' => 'delete', $allergensProduct->id],
                ['confirm' => __('Are you sure you want to delete # {0}?', $allergensProduct->id), 'class' => 'side-nav-item']
            ) ?>
            <?= $this->Html->link(__('List Allergens Products'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="allergensProducts form content">
            <?= $this->Form->create($allergensProduct) ?>
            <fieldset>
                <legend><?= __('Edit Allergens Product') ?></legend>
                <?php
                    echo $this->Form->control('allergen_id', ['options' => $allergens]);
                    echo $this->Form->control('product_id', ['options' => $products]);
                ?>
            </fieldset>
            <?= $this->Form->button(__('Submit')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
