<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Allergen $allergen
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('Edit Allergen'), ['action' => 'edit', $allergen->id], ['class' => 'side-nav-item']) ?>
            <?= $this->Form->postLink(__('Delete Allergen'), ['action' => 'delete', $allergen->id], ['confirm' => __('Are you sure you want to delete # {0}?', $allergen->id), 'class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('List Allergens'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
            <?= $this->Html->link(__('New Allergen'), ['action' => 'add'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="allergens view content">
            <h3><?= h($allergen->allergen_name) ?></h3>
            <table>
                <tr>
                    <th><?= __('Allergen Name') ?></th>
                    <td><?= h($allergen->allergen_name) ?></td>
                </tr>
                <tr>
                    <th><?= __('Allergen Logo Url') ?></th>
                    <td><?= h($allergen->allergen_logo_url) ?></td>
                </tr>
                <tr>
                    <th><?= __('Id') ?></th>
                    <td><?= $this->Number->format($allergen->id) ?></td>
                </tr>
            </table>
            <div class="related">
                <h4><?= __('Related Products') ?></h4>
                <?php if (!empty($allergen->products)) : ?>
                <div class="table-responsive">
                    <table>
                        <tr>
                            <th><?= __('Id') ?></th>
                            <th><?= __('Name') ?></th>
                            <th><?= __('Description') ?></th>
                            <th><?= __('Price') ?></th>
                            <th><?= __('Stock Level') ?></th>
                            <th><?= __('Is Seasonal') ?></th>
                            <th><?= __('Is Available') ?></th>
                            <th><?= __('Product Image Url') ?></th>
                            <th><?= __('Created') ?></th>
                            <th><?= __('Modified') ?></th>
                            <th class="actions"><?= __('Actions') ?></th>
                        </tr>
                        <?php foreach ($allergen->products as $product) : ?>
                        <tr>
                            <td><?= h($product->id) ?></td>
                            <td><?= h($product->name) ?></td>
                            <td><?= h($product->description) ?></td>
                            <td><?= h($product->price) ?></td>
                            <td><?= h($product->stock_level) ?></td>
                            <td><?= h($product->is_seasonal) ?></td>
                            <td><?= h($product->is_available) ?></td>
                            <td><?= h($product->product_image_url) ?></td>
                            <td><?= h($product->created) ?></td>
                            <td><?= h($product->modified) ?></td>
                            <td class="actions">
                                <?= $this->Html->link(__('View'), ['controller' => 'Products', 'action' => 'view', $product->id]) ?>
                                <?= $this->Html->link(__('Edit'), ['controller' => 'Products', 'action' => 'edit', $product->id]) ?>
                                <?= $this->Form->postLink(
                                    __('Delete'),
                                    ['controller' => 'Products', 'action' => 'delete', $product->id],
                                    [
                                        'method' => 'delete',
                                        'confirm' => __('Are you sure you want to delete # {0}?', $product->id),
                                    ]
                                ) ?>
                            </td>
                        </tr>
                        <?php endforeach; ?>
                    </table>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
</div>