<?php
/**
 * @var \App\View\AppView $this
 * @var iterable<\App\Model\Entity\Allergen> $allergens
 */
?>
<div class="allergens index content">
    <?= $this->Html->link(__('New Allergen'), ['action' => 'add'], ['class' => 'button float-right']) ?>
    <h3><?= __('Allergens') ?></h3>
    <div class="table-responsive">
        <table>
            <thead>
                <tr>
                    <th><?= $this->Paginator->sort('id') ?></th>
                    <th><?= $this->Paginator->sort('allergen_name') ?></th>
                    <th><?= $this->Paginator->sort('allergen_logo_url') ?></th>
                    <th class="actions"><?= __('Actions') ?></th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($allergens as $allergen): ?>
                <tr>
                    <td><?= $this->Number->format($allergen->id) ?></td>
                    <td><?= h($allergen->allergen_name) ?></td>
                    <td><?= h($allergen->allergen_logo_url) ?></td>
                    <td class="actions">
                        <?= $this->Html->link(__('View'), ['action' => 'view', $allergen->id]) ?>
                        <?= $this->Html->link(__('Edit'), ['action' => 'edit', $allergen->id]) ?>
                        <?= $this->Form->postLink(
                            __('Delete'),
                            ['action' => 'delete', $allergen->id],
                            [
                                'method' => 'delete',
                                'confirm' => __('Are you sure you want to delete # {0}?', $allergen->id),
                            ]
                        ) ?>
                    </td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <div class="paginator">
        <ul class="pagination">
            <?= $this->Paginator->first('<< ' . __('first')) ?>
            <?= $this->Paginator->prev('< ' . __('previous')) ?>
            <?= $this->Paginator->numbers() ?>
            <?= $this->Paginator->next(__('next') . ' >') ?>
            <?= $this->Paginator->last(__('last') . ' >>') ?>
        </ul>
        <p><?= $this->Paginator->counter(__('Page {{page}} of {{pages}}, showing {{current}} record(s) out of {{count}} total')) ?></p>
    </div>
</div>