<?php
/**
 * @var \App\View\AppView $this
 * @var \App\Model\Entity\Allergen $allergen
 * @var \Cake\Collection\CollectionInterface|string[] $products
 */
?>
<div class="row">
    <aside class="column">
        <div class="side-nav">
            <h4 class="heading"><?= __('Actions') ?></h4>
            <?= $this->Html->link(__('List Allergens'), ['action' => 'index'], ['class' => 'side-nav-item']) ?>
        </div>
    </aside>
    <div class="column column-80">
        <div class="allergens form content">
            <?= $this->Form->create($allergen) ?>
            <fieldset>
                <legend><?= __('Add Allergen') ?></legend>
                <?php
                    echo $this->Form->control('allergen_name');
                    echo $this->Form->control('allergen_logo_url');
                    echo $this->Form->control('products._ids', ['options' => $products]);
                ?>
            </fieldset>
            <?= $this->Form->button(__('Submit')) ?>
            <?= $this->Form->end() ?>
        </div>
    </div>
</div>
