<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Allergens Model
 *
 * @property \App\Model\Table\ProductsTable&\Cake\ORM\Association\BelongsToMany $Products
 */
class AllergensTable extends Table
{
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('allergens');
        $this->setDisplayField('allergen_name'); // column in your table
        $this->setPrimaryKey('id');

        // Many-to-many back to products via join table
        $this->belongsToMany('Products', [
            'joinTable'        => 'allergens_products',
            'foreignKey'       => 'allergen_id',
            'targetForeignKey' => 'product_id',
        ]);
    }

    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->scalar('allergen_name')
            ->maxLength('allergen_name', 128)
            ->requirePresence('allergen_name', 'create')
            ->notEmptyString('allergen_name');

        $validator
            ->scalar('allergen_logo_url')
            ->maxLength('allergen_logo_url', 255)
            ->allowEmptyString('allergen_logo_url');

        return $validator;
    }
}
