<?php
declare(strict_types=1);

namespace App\Model\Table;

use Cake\ORM\Query\SelectQuery;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * AllergensProducts Model
 *
 * @property \App\Model\Table\AllergensTable&\Cake\ORM\Association\BelongsTo $Allergens
 * @property \App\Model\Table\ProductsTable&\Cake\ORM\Association\BelongsTo $Products
 *
 * @method \App\Model\Entity\AllergensProduct newEmptyEntity()
 * @method \App\Model\Entity\AllergensProduct newEntity(array $data, array $options = [])
 * @method array<\App\Model\Entity\AllergensProduct> newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\AllergensProduct get(mixed $primaryKey, array|string $finder = 'all', \Psr\SimpleCache\CacheInterface|string|null $cache = null, \Closure|string|null $cacheKey = null, mixed ...$args)
 * @method \App\Model\Entity\AllergensProduct findOrCreate($search, ?callable $callback = null, array $options = [])
 * @method \App\Model\Entity\AllergensProduct patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method array<\App\Model\Entity\AllergensProduct> patchEntities(iterable $entities, array $data, array $options = [])
 * @method \App\Model\Entity\AllergensProduct|false save(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method \App\Model\Entity\AllergensProduct saveOrFail(\Cake\Datasource\EntityInterface $entity, array $options = [])
 * @method iterable<\App\Model\Entity\AllergensProduct>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\AllergensProduct>|false saveMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\AllergensProduct>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\AllergensProduct> saveManyOrFail(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\AllergensProduct>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\AllergensProduct>|false deleteMany(iterable $entities, array $options = [])
 * @method iterable<\App\Model\Entity\AllergensProduct>|\Cake\Datasource\ResultSetInterface<\App\Model\Entity\AllergensProduct> deleteManyOrFail(iterable $entities, array $options = [])
 */
class AllergensProductsTable extends Table
{
    /**
     * Initialize method
     *
     * @param array<string, mixed> $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config): void
    {
        parent::initialize($config);

        $this->setTable('allergens_products');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');

        $this->belongsTo('Allergens', [
            'foreignKey' => 'allergen_id',
            'joinType' => 'INNER',
        ]);
        $this->belongsTo('Products', [
            'foreignKey' => 'product_id',
            'joinType' => 'INNER',
        ]);
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator): Validator
    {
        $validator
            ->nonNegativeInteger('allergen_id')
            ->notEmptyString('allergen_id');

        $validator
            ->nonNegativeInteger('product_id')
            ->notEmptyString('product_id');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules): RulesChecker
    {
        $rules->add($rules->isUnique(['allergen_id', 'product_id']), ['errorField' => 'allergen_id']);
        $rules->add($rules->existsIn(['allergen_id'], 'Allergens'), ['errorField' => 'allergen_id']);
        $rules->add($rules->existsIn(['product_id'], 'Products'), ['errorField' => 'product_id']);

        return $rules;
    }
}
