<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * User Entity
 *
 * @property int $id
 * @property string $role
 * @property string $username
 * @property string $email
 * @property string $password
 * @property bool $marketing_opt_in
 * @property \Cake\I18n\DateTime|null $created
 * @property \Cake\I18n\DateTime|null $modified
 *
 * @property \App\Model\Entity\Cart[] $carts
 * @property \App\Model\Entity\ContactSubmission[] $contact_submissions
 * @property \App\Model\Entity\Order[] $orders
 */
class User extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'role' => true,
        'username' => true,
        'email' => true,
        'password' => true,
        'marketing_opt_in' => true,
        'created' => true,
        'modified' => true,
        'carts' => true,
        'contact_submissions' => true,
        'orders' => true,
    ];

    /**
     * Fields that are excluded from JSON versions of the entity.
     *
     * @var list<string>
     */
    protected array $_hidden = [
        'password', 'password_reset_token'
    ];
}
