<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Order Entity
 *
 * @property int $id
 * @property int $user_id
 * @property string $name
 * @property string $email
 * @property string|null $phone
 * @property string $order_address
 * @property string|null $provider_txn_id
 * @property string|null $provider
 * @property string|null $tracking_number
 * @property string $order_status
 * @property string $payment_status
 * @property string $total_amount
 * @property string|null $refund_reason
 * @property string|null $refund_status
 * @property \Cake\I18n\DateTime|null $created
 * @property \Cake\I18n\DateTime|null $modified
 *
 * @property \App\Model\Entity\User $user
 * @property \App\Model\Entity\OrderProduct[] $order_products
 */
class Order extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'user_id' => true,
        'name' => true,
        'email' => true,
        'phone' => true,
        'order_address' => true,
        'provider_txn_id' => true,
        'provider' => true,
        'tracking_number' => true,
        'order_status' => true,
        'payment_status' => true,
        'total_amount' => true,
        'refund_reason' => true,
        'refund_status' => true,
        'created' => true,
        'modified' => true,
        'user' => true,
        'order_products' => true,
    ];
}
