<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * AllergensProduct Entity
 *
 * @property int $id
 * @property int $allergen_id
 * @property int $product_id
 *
 * @property \App\Model\Entity\Allergen $allergen
 * @property \App\Model\Entity\Product $product
 */
class AllergensProduct extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'allergen_id' => true,
        'product_id' => true,
        'allergen' => true,
        'product' => true,
    ];
}
