<?php
declare(strict_types=1);

namespace App\Model\Entity;

use Cake\ORM\Entity;

/**
 * Allergen Entity
 *
 * @property int $id
 * @property string $allergen_name
 * @property string|null $allergen_logo_url
 *
 * @property \App\Model\Entity\Product[] $products
 */
class Allergen extends Entity
{
    /**
     * Fields that can be mass assigned using newEntity() or patchEntity().
     *
     * Note that when '*' is set to true, this allows all unspecified fields to
     * be mass assigned. For security purposes, it is advised to set '*' to false
     * (or remove it), and explicitly make individual fields accessible as needed.
     *
     * @var array<string, bool>
     */
    protected array $_accessible = [
        'allergen_name' => true,
        'allergen_logo_url' => true,
        'products' => true,
    ];
}
