<?php
declare(strict_types=1);

namespace App\Controller;

/**
 * AllergensProducts Controller
 *
 * @property \App\Model\Table\AllergensProductsTable $AllergensProducts
 */
class AllergensProductsController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $query = $this->AllergensProducts->find()
            ->contain(['Allergens', 'Products']);
        $allergensProducts = $this->paginate($query);

        $this->set(compact('allergensProducts'));
    }

    /**
     * View method
     *
     * @param string|null $id Allergens Product id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $allergensProduct = $this->AllergensProducts->get($id, contain: ['Allergens', 'Products']);
        $this->set(compact('allergensProduct'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $allergensProduct = $this->AllergensProducts->newEmptyEntity();
        if ($this->request->is('post')) {
            $allergensProduct = $this->AllergensProducts->patchEntity($allergensProduct, $this->request->getData());
            if ($this->AllergensProducts->save($allergensProduct)) {
                $this->Flash->success(__('The allergens product has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The allergens product could not be saved. Please, try again.'));
        }
        $allergens = $this->AllergensProducts->Allergens->find('list', limit: 200)->all();
        $products = $this->AllergensProducts->Products->find('list', limit: 200)->all();
        $this->set(compact('allergensProduct', 'allergens', 'products'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Allergens Product id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $allergensProduct = $this->AllergensProducts->get($id, contain: []);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $allergensProduct = $this->AllergensProducts->patchEntity($allergensProduct, $this->request->getData());
            if ($this->AllergensProducts->save($allergensProduct)) {
                $this->Flash->success(__('The allergens product has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The allergens product could not be saved. Please, try again.'));
        }
        $allergens = $this->AllergensProducts->Allergens->find('list', limit: 200)->all();
        $products = $this->AllergensProducts->Products->find('list', limit: 200)->all();
        $this->set(compact('allergensProduct', 'allergens', 'products'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Allergens Product id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $allergensProduct = $this->AllergensProducts->get($id);
        if ($this->AllergensProducts->delete($allergensProduct)) {
            $this->Flash->success(__('The allergens product has been deleted.'));
        } else {
            $this->Flash->error(__('The allergens product could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
