<?php
declare(strict_types=1);

namespace App\Controller;

/**
 * Allergens Controller
 *
 * @property \App\Model\Table\AllergensTable $Allergens
 */
class AllergensController extends AppController
{
    /**
     * Index method
     *
     * @return \Cake\Http\Response|null|void Renders view
     */
    public function index()
    {
        $query = $this->Allergens->find();
        $allergens = $this->paginate($query);

        $this->set(compact('allergens'));
    }

    /**
     * View method
     *
     * @param string|null $id Allergen id.
     * @return \Cake\Http\Response|null|void Renders view
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function view($id = null)
    {
        $allergen = $this->Allergens->get($id, contain: ['Products']);
        $this->set(compact('allergen'));
    }

    /**
     * Add method
     *
     * @return \Cake\Http\Response|null|void Redirects on successful add, renders view otherwise.
     */
    public function add()
    {
        $allergen = $this->Allergens->newEmptyEntity();
        if ($this->request->is('post')) {
            $allergen = $this->Allergens->patchEntity($allergen, $this->request->getData());
            if ($this->Allergens->save($allergen)) {
                $this->Flash->success(__('The allergen has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The allergen could not be saved. Please, try again.'));
        }
        $products = $this->Allergens->Products->find('list', limit: 200)->all();
        $this->set(compact('allergen', 'products'));
    }

    /**
     * Edit method
     *
     * @param string|null $id Allergen id.
     * @return \Cake\Http\Response|null|void Redirects on successful edit, renders view otherwise.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function edit($id = null)
    {
        $allergen = $this->Allergens->get($id, contain: ['Products']);
        if ($this->request->is(['patch', 'post', 'put'])) {
            $allergen = $this->Allergens->patchEntity($allergen, $this->request->getData());
            if ($this->Allergens->save($allergen)) {
                $this->Flash->success(__('The allergen has been saved.'));

                return $this->redirect(['action' => 'index']);
            }
            $this->Flash->error(__('The allergen could not be saved. Please, try again.'));
        }
        $products = $this->Allergens->Products->find('list', limit: 200)->all();
        $this->set(compact('allergen', 'products'));
    }

    /**
     * Delete method
     *
     * @param string|null $id Allergen id.
     * @return \Cake\Http\Response|null Redirects to index.
     * @throws \Cake\Datasource\Exception\RecordNotFoundException When record not found.
     */
    public function delete($id = null)
    {
        $this->request->allowMethod(['post', 'delete']);
        $allergen = $this->Allergens->get($id);
        if ($this->Allergens->delete($allergen)) {
            $this->Flash->success(__('The allergen has been deleted.'));
        } else {
            $this->Flash->error(__('The allergen could not be deleted. Please, try again.'));
        }

        return $this->redirect(['action' => 'index']);
    }
}
