<?php
/**
 * Routes configuration.
 *
 * In this file, you set up routes to your controllers and their actions.
 * Routes are very important mechanism that allows you to freely connect
 * different URLs to chosen controllers and their actions (functions).
 *
 * It's loaded within the context of `Application::routes()` method which
 * receives a `RouteBuilder` instance `$routes` as method argument.
 */

use Cake\Routing\Route\DashedRoute;
use Cake\Routing\RouteBuilder;

return function (RouteBuilder $routes): void {
    // Set the default route class
    $routes->setRouteClass(DashedRoute::class);

    $routes->scope('/', function (RouteBuilder $builder): void {
        /*
         * Root (/) → PagesController::home()
         */
        $builder->connect('/', ['controller' => 'Pages', 'action' => 'home']);

        /*
         * Optional: keep /home working too → PagesController::home()
         */
        $builder->connect('/home', ['controller' => 'Pages', 'action' => 'home']);

        $builder->connect('/login', ['controller' => 'Users', 'action' => 'login']);
        $builder->connect('/logout', ['controller' => 'Users', 'action' => 'logout']);
        $builder->connect('/forgot-password', ['controller' => 'Users', 'action' => 'forgotPassword']);
        $builder->connect('/reset-password/*', ['controller' => 'Users', 'action' => 'resetPassword']);
        $builder->connect('/admin', ['controller' => 'Dashboard', 'action' => 'index']);

        $builder->connect('/cart',               ['controller' => 'Carts', 'action' => 'cart']);
        $builder->connect('/cart/add/*', ['controller' => 'Carts', 'action' => 'addItem']);
        $builder->connect('/cart/remove/*', ['controller' => 'Carts', 'action' => 'removeItem']);
        $builder->connect('/cart/update',        ['controller' => 'Carts', 'action' => 'update']);    // POST
        $builder->connect('/cart/clear',         ['controller' => 'Carts', 'action' => 'clear']);     // POST
        $builder->connect('/checkout',           ['controller' => 'Carts', 'action' => 'checkout']);  // GET/POST
        $builder->connect('/signup',   ['controller' => 'Users', 'action' => 'register']);
        $builder->connect('/register', ['controller' => 'Users', 'action' => 'register']);
        $builder->connect('/products/listProducts', ['controller' => 'Products', 'action' => 'listProducts']);

        /*
         * Connect the rest of 'Pages' controller's URLs.
         */
        $builder->connect('/pages/*', 'Pages::display');

        /*
         * Fallback routes for all controllers
         */
        $builder->fallbacks();


    });
};
