<?php
declare(strict_types=1);

use Migrations\BaseMigration;

class AddPasswordResetToUsers extends BaseMigration
{
    /**
     * Change Method.
     *
     * More information on this method is available here:
     * https://book.cakephp.org/migrations/4/en/migrations.html#the-change-method
     *
     * @return void
     */
    public function change(): void
    {
        $table = $this->table('users');
        $table->addColumn('password_reset_token', 'string', [
            'default' => null,
            'limit' => 128,
            'null' => false,
        ]);
        $table->addColumn('password_reset_expires', 'datetime', [
            'default' => null,
            'null' => false,
        ]);
        $table->addIndex([
            'password_reset_token',
        
            ], [
            'name' => 'BY_PASSWORD_RESET_TOKEN',
            'unique' => false,
        ]);
        $table->addIndex([
            'password_reset_expires',
        
            ], [
            'name' => 'BY_PASSWORD_RESET_EXPIRES',
            'unique' => false,
        ]);
        $table->update();
    }
}
